package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.LogicalPermissionMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LogicalPermissionMapperConsumer<T extends LogicalPermissionMapper<T>> {

	/**
	 * Configure a pre-constructed instance of LogicalPermissionMapper resource
	 * 
	 * @parameter Instance of LogicalPermissionMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default LogicalPermissionMapperConsumer<T> andThen(
			LogicalPermissionMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}