package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A security realm definition backed by properties files.
 */
@Address("/subsystem=elytron/properties-realm=*")
@ResourceType("properties-realm")
public class PropertiesRealm<T extends PropertiesRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the attribute in the returned AuthorizationIdentity that should contain the group membership information for the identity.")
	private String groupsAttribute;
	@AttributeDocumentation("The properties file containing the users and their groups.")
	private Map groupsProperties;
	@AttributeDocumentation("The time the properties files that back this realm were last loaded.")
	private String attributeSynchronized;
	@AttributeDocumentation("The properties file containing the users and their passwords.")
	private Map usersProperties;

	public PropertiesRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the attribute in the returned AuthorizationIdentity that
	 * should contain the group membership information for the identity.
	 */
	@ModelNodeBinding(detypedName = "groups-attribute")
	public String groupsAttribute() {
		return this.groupsAttribute;
	}

	/**
	 * The name of the attribute in the returned AuthorizationIdentity that
	 * should contain the group membership information for the identity.
	 */
	@SuppressWarnings("unchecked")
	public T groupsAttribute(java.lang.String value) {
		Object oldValue = this.groupsAttribute;
		this.groupsAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupsAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties file containing the users and their groups.
	 */
	@ModelNodeBinding(detypedName = "groups-properties")
	public Map groupsProperties() {
		return this.groupsProperties;
	}

	/**
	 * The properties file containing the users and their groups.
	 */
	@SuppressWarnings("unchecked")
	public T groupsProperties(java.util.Map value) {
		Object oldValue = this.groupsProperties;
		this.groupsProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupsProperties", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties file containing the users and their groups.
	 */
	@SuppressWarnings("unchecked")
	public T groupsProperty(java.lang.String key, java.lang.Object value) {
		if (this.groupsProperties == null) {
			this.groupsProperties = new java.util.HashMap<>();
		}
		this.groupsProperties.put(key, value);
		return (T) this;
	}

	/**
	 * The time the properties files that back this realm were last loaded.
	 */
	@ModelNodeBinding(detypedName = "synchronized")
	public String attributeSynchronized() {
		return this.attributeSynchronized;
	}

	/**
	 * The time the properties files that back this realm were last loaded.
	 */
	@SuppressWarnings("unchecked")
	public T attributeSynchronized(java.lang.String value) {
		Object oldValue = this.attributeSynchronized;
		this.attributeSynchronized = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeSynchronized", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The properties file containing the users and their passwords.
	 */
	@ModelNodeBinding(detypedName = "users-properties")
	public Map usersProperties() {
		return this.usersProperties;
	}

	/**
	 * The properties file containing the users and their passwords.
	 */
	@SuppressWarnings("unchecked")
	public T usersProperties(java.util.Map value) {
		Object oldValue = this.usersProperties;
		this.usersProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("usersProperties", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties file containing the users and their passwords.
	 */
	@SuppressWarnings("unchecked")
	public T usersProperty(java.lang.String key, java.lang.Object value) {
		if (this.usersProperties == null) {
			this.usersProperties = new java.util.HashMap<>();
		}
		this.usersProperties.put(key, value);
		return (T) this;
	}
}