package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A regular expression based principal transformer which uses the regular
 * expression to validate the name.
 */
@Address("/subsystem=elytron/regex-validating-principal-transformer=*")
@ResourceType("regex-validating-principal-transformer")
public class RegexValidatingPrincipalTransformer<T extends RegexValidatingPrincipalTransformer<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("If set to true, the name must match the given pattern to make validation successful. If set to false, the name must not match the given pattern to make validation successful.")
	private Boolean match;
	@AttributeDocumentation("The regular expression to use for the principal transformer.")
	private String pattern;

	public RegexValidatingPrincipalTransformer(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If set to true, the name must match the given pattern to make validation
	 * successful. If set to false, the name must not match the given pattern to
	 * make validation successful.
	 */
	@ModelNodeBinding(detypedName = "match")
	public Boolean match() {
		return this.match;
	}

	/**
	 * If set to true, the name must match the given pattern to make validation
	 * successful. If set to false, the name must not match the given pattern to
	 * make validation successful.
	 */
	@SuppressWarnings("unchecked")
	public T match(java.lang.Boolean value) {
		Object oldValue = this.match;
		this.match = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("match", oldValue, value);
		return (T) this;
	}

	/**
	 * The regular expression to use for the principal transformer.
	 */
	@ModelNodeBinding(detypedName = "pattern")
	public String pattern() {
		return this.pattern;
	}

	/**
	 * The regular expression to use for the principal transformer.
	 */
	@SuppressWarnings("unchecked")
	public T pattern(java.lang.String value) {
		Object oldValue = this.pattern;
		this.pattern = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("pattern", oldValue, value);
		return (T) this;
	}
}