package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.RegexValidatingPrincipalTransformer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RegexValidatingPrincipalTransformerConsumer<T extends RegexValidatingPrincipalTransformer<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * RegexValidatingPrincipalTransformer resource
	 * 
	 * @parameter Instance of RegexValidatingPrincipalTransformer to configure
	 * @return nothing
	 */
	void accept(T value);

	default RegexValidatingPrincipalTransformerConsumer<T> andThen(
			RegexValidatingPrincipalTransformerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}