package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * A security domain definition.
 */
@Address("/subsystem=elytron/security-domain=*")
@ResourceType("security-domain")
public class SecurityDomain<T extends SecurityDomain<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The default realm contained by this security domain.")
	private String defaultRealm;
	@AttributeDocumentation("When outflowing to a security domain if outflow is not possible should the anonymous identity be used?  Outflowing anonymous has the effect of clearing any identity already established for that domain.")
	private Boolean outflowAnonymous;
	@AttributeDocumentation("The list of security domains that the security identity from this domain should automatically outflow to.")
	private List<String> outflowSecurityDomains;
	@AttributeDocumentation("A reference to a PermissionMapper to be used by this domain.")
	private String permissionMapper;
	@AttributeDocumentation("A reference to a principal transformer to be applied after the realm has operated on the supplied identity name.")
	private String postRealmPrincipalTransformer;
	@AttributeDocumentation("A reference to a principal transformer to be applied before the realm is selected.")
	private String preRealmPrincipalTransformer;
	@AttributeDocumentation("A reference to a PrincipalDecoder to be used by this domain.")
	private String principalDecoder;
	@AttributeDocumentation("Reference to the RealmMapper to be used by this domain.")
	private String realmMapper;
	@AttributeDocumentation("The list of realms contained by this security domain.")
	private List<java.util.Map> realms;
	@AttributeDocumentation("Reference to the RoleMapper to be used by this domain.")
	private String roleMapper;
	@AttributeDocumentation("Reference to a listener for security events.")
	private String securityEventListener;
	@AttributeDocumentation("The list of security domains that are trusted by this security domain.")
	private List<String> trustedSecurityDomains;

	public SecurityDomain(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The default realm contained by this security domain.
	 */
	@ModelNodeBinding(detypedName = "default-realm")
	public String defaultRealm() {
		return this.defaultRealm;
	}

	/**
	 * The default realm contained by this security domain.
	 */
	@SuppressWarnings("unchecked")
	public T defaultRealm(java.lang.String value) {
		Object oldValue = this.defaultRealm;
		this.defaultRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * When outflowing to a security domain if outflow is not possible should
	 * the anonymous identity be used? Outflowing anonymous has the effect of
	 * clearing any identity already established for that domain.
	 */
	@ModelNodeBinding(detypedName = "outflow-anonymous")
	public Boolean outflowAnonymous() {
		return this.outflowAnonymous;
	}

	/**
	 * When outflowing to a security domain if outflow is not possible should
	 * the anonymous identity be used? Outflowing anonymous has the effect of
	 * clearing any identity already established for that domain.
	 */
	@SuppressWarnings("unchecked")
	public T outflowAnonymous(java.lang.Boolean value) {
		Object oldValue = this.outflowAnonymous;
		this.outflowAnonymous = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("outflowAnonymous", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of security domains that the security identity from this domain
	 * should automatically outflow to.
	 */
	@ModelNodeBinding(detypedName = "outflow-security-domains")
	public List<String> outflowSecurityDomains() {
		return this.outflowSecurityDomains;
	}

	/**
	 * The list of security domains that the security identity from this domain
	 * should automatically outflow to.
	 */
	@SuppressWarnings("unchecked")
	public T outflowSecurityDomains(java.util.List<String> value) {
		Object oldValue = this.outflowSecurityDomains;
		this.outflowSecurityDomains = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("outflowSecurityDomains", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The list of security domains that the security identity from this domain
	 * should automatically outflow to.
	 */
	@SuppressWarnings("unchecked")
	public T outflowSecurityDomain(String value) {
		if (this.outflowSecurityDomains == null) {
			this.outflowSecurityDomains = new java.util.ArrayList<>();
		}
		this.outflowSecurityDomains.add(value);
		return (T) this;
	}

	/**
	 * The list of security domains that the security identity from this domain
	 * should automatically outflow to.
	 */
	@SuppressWarnings("unchecked")
	public T outflowSecurityDomains(String... args) {
		outflowSecurityDomains(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * A reference to a PermissionMapper to be used by this domain.
	 */
	@ModelNodeBinding(detypedName = "permission-mapper")
	public String permissionMapper() {
		return this.permissionMapper;
	}

	/**
	 * A reference to a PermissionMapper to be used by this domain.
	 */
	@SuppressWarnings("unchecked")
	public T permissionMapper(java.lang.String value) {
		Object oldValue = this.permissionMapper;
		this.permissionMapper = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("permissionMapper", oldValue, value);
		return (T) this;
	}

	/**
	 * A reference to a principal transformer to be applied after the realm has
	 * operated on the supplied identity name.
	 */
	@ModelNodeBinding(detypedName = "post-realm-principal-transformer")
	public String postRealmPrincipalTransformer() {
		return this.postRealmPrincipalTransformer;
	}

	/**
	 * A reference to a principal transformer to be applied after the realm has
	 * operated on the supplied identity name.
	 */
	@SuppressWarnings("unchecked")
	public T postRealmPrincipalTransformer(java.lang.String value) {
		Object oldValue = this.postRealmPrincipalTransformer;
		this.postRealmPrincipalTransformer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("postRealmPrincipalTransformer",
					oldValue, value);
		return (T) this;
	}

	/**
	 * A reference to a principal transformer to be applied before the realm is
	 * selected.
	 */
	@ModelNodeBinding(detypedName = "pre-realm-principal-transformer")
	public String preRealmPrincipalTransformer() {
		return this.preRealmPrincipalTransformer;
	}

	/**
	 * A reference to a principal transformer to be applied before the realm is
	 * selected.
	 */
	@SuppressWarnings("unchecked")
	public T preRealmPrincipalTransformer(java.lang.String value) {
		Object oldValue = this.preRealmPrincipalTransformer;
		this.preRealmPrincipalTransformer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("preRealmPrincipalTransformer",
					oldValue, value);
		return (T) this;
	}

	/**
	 * A reference to a PrincipalDecoder to be used by this domain.
	 */
	@ModelNodeBinding(detypedName = "principal-decoder")
	public String principalDecoder() {
		return this.principalDecoder;
	}

	/**
	 * A reference to a PrincipalDecoder to be used by this domain.
	 */
	@SuppressWarnings("unchecked")
	public T principalDecoder(java.lang.String value) {
		Object oldValue = this.principalDecoder;
		this.principalDecoder = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalDecoder", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the RealmMapper to be used by this domain.
	 */
	@ModelNodeBinding(detypedName = "realm-mapper")
	public String realmMapper() {
		return this.realmMapper;
	}

	/**
	 * Reference to the RealmMapper to be used by this domain.
	 */
	@SuppressWarnings("unchecked")
	public T realmMapper(java.lang.String value) {
		Object oldValue = this.realmMapper;
		this.realmMapper = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realmMapper", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of realms contained by this security domain.
	 */
	@ModelNodeBinding(detypedName = "realms")
	public List<Map> realms() {
		return this.realms;
	}

	/**
	 * The list of realms contained by this security domain.
	 */
	@SuppressWarnings("unchecked")
	public T realms(java.util.List<java.util.Map> value) {
		Object oldValue = this.realms;
		this.realms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realms", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of realms contained by this security domain.
	 */
	@SuppressWarnings("unchecked")
	public T realm(java.util.Map value) {
		if (this.realms == null) {
			this.realms = new java.util.ArrayList<>();
		}
		this.realms.add(value);
		return (T) this;
	}

	/**
	 * The list of realms contained by this security domain.
	 */
	@SuppressWarnings("unchecked")
	public T realms(java.util.Map... args) {
		realms(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Reference to the RoleMapper to be used by this domain.
	 */
	@ModelNodeBinding(detypedName = "role-mapper")
	public String roleMapper() {
		return this.roleMapper;
	}

	/**
	 * Reference to the RoleMapper to be used by this domain.
	 */
	@SuppressWarnings("unchecked")
	public T roleMapper(java.lang.String value) {
		Object oldValue = this.roleMapper;
		this.roleMapper = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("roleMapper", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to a listener for security events.
	 */
	@ModelNodeBinding(detypedName = "security-event-listener")
	public String securityEventListener() {
		return this.securityEventListener;
	}

	/**
	 * Reference to a listener for security events.
	 */
	@SuppressWarnings("unchecked")
	public T securityEventListener(java.lang.String value) {
		Object oldValue = this.securityEventListener;
		this.securityEventListener = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityEventListener", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The list of security domains that are trusted by this security domain.
	 */
	@ModelNodeBinding(detypedName = "trusted-security-domains")
	public List<String> trustedSecurityDomains() {
		return this.trustedSecurityDomains;
	}

	/**
	 * The list of security domains that are trusted by this security domain.
	 */
	@SuppressWarnings("unchecked")
	public T trustedSecurityDomains(java.util.List<String> value) {
		Object oldValue = this.trustedSecurityDomains;
		this.trustedSecurityDomains = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("trustedSecurityDomains", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The list of security domains that are trusted by this security domain.
	 */
	@SuppressWarnings("unchecked")
	public T trustedSecurityDomain(String value) {
		if (this.trustedSecurityDomains == null) {
			this.trustedSecurityDomains = new java.util.ArrayList<>();
		}
		this.trustedSecurityDomains.add(value);
		return (T) this;
	}

	/**
	 * The list of security domains that are trusted by this security domain.
	 */
	@SuppressWarnings("unchecked")
	public T trustedSecurityDomains(String... args) {
		trustedSecurityDomains(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}