package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.SimplePermissionMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SimplePermissionMapperConsumer<T extends SimplePermissionMapper<T>> {

	/**
	 * Configure a pre-constructed instance of SimplePermissionMapper resource
	 * 
	 * @parameter Instance of SimplePermissionMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default SimplePermissionMapperConsumer<T> andThen(
			SimplePermissionMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}