package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.TokenRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TokenRealmConsumer<T extends TokenRealm<T>> {

	/**
	 * Configure a pre-constructed instance of TokenRealm resource
	 * 
	 * @parameter Instance of TokenRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default TokenRealmConsumer<T> andThen(TokenRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}