package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.cache_container.BackupConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.BackupSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.Backup;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The remote backups for this cache.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=backups",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/component=backups"})
@ResourceType("component")
@Implicit
public class BackupsComponent<T extends BackupsComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private BackupsComponentResources subresources = new BackupsComponentResources();

	public BackupsComponent() {
		super();
		this.key = "backups";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public BackupsComponentResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Backup objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Backup objects.
	 */
	@SuppressWarnings("unchecked")
	public T backups(java.util.List<Backup> value) {
		this.subresources.backups = value;
		return (T) this;
	}

	/**
	 * Add the Backup object to the list of subresources
	 * 
	 * @param value
	 *            The Backup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T backup(Backup value) {
		this.subresources.backups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Backup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Backup resource
	 * @param config
	 *            The BackupConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T backup(java.lang.String childKey, BackupConsumer consumer) {
		Backup<? extends Backup> child = new Backup<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		backup(child);
		return (T) this;
	}

	/**
	 * Create and configure a Backup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Backup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T backup(java.lang.String childKey) {
		backup(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Backup object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T backup(BackupSupplier supplier) {
		backup(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for BackupsComponent
	 */
	public static class BackupsComponentResources {
		/**
		 * A backup site to which to replicate this cache.
		 */
		@ResourceDocumentation("A backup site to which to replicate this cache.")
		@SubresourceInfo("backup")
		private List<Backup> backups = new java.util.ArrayList<>();

		/**
		 * Get the list of Backup resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Backup> backups() {
			return this.backups;
		}

		public Backup backup(java.lang.String key) {
			return this.backups.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}
}