package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.Property;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PropertyConsumer<T extends Property<T>> {

	/**
	 * Configure a pre-constructed instance of Property resource
	 * 
	 * @parameter Instance of Property to configure
	 * @return nothing
	 */
	void accept(T value);

	default PropertyConsumer<T> andThen(PropertyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}