package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.StringTable;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface StringTableConsumer<T extends StringTable<T>> {

	/**
	 * Configure a pre-constructed instance of StringTable resource
	 * 
	 * @parameter Instance of StringTable to configure
	 * @return nothing
	 */
	void accept(T value);

	default StringTableConsumer<T> andThen(StringTableConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}