package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Bootstrap context for resource adapters
 */
@Address("/subsystem=jca/bootstrap-context=*")
@ResourceType("bootstrap-context")
public class BootstrapContext<T extends BootstrapContext<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the BootstrapContext")
	private String name;
	@AttributeDocumentation("The WorkManager instance for the BootstrapContext")
	private String workmanager;

	public BootstrapContext(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the BootstrapContext
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the BootstrapContext
	 */
	@SuppressWarnings("unchecked")
	public T name(java.lang.String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * The WorkManager instance for the BootstrapContext
	 */
	@ModelNodeBinding(detypedName = "workmanager")
	public String workmanager() {
		return this.workmanager;
	}

	/**
	 * The WorkManager instance for the BootstrapContext
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(java.lang.String value) {
		Object oldValue = this.workmanager;
		this.workmanager = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workmanager", oldValue, value);
		return (T) this;
	}
}