package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.jca.LongRunningThreads;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LongRunningThreadsConsumer<T extends LongRunningThreads<T>> {

	/**
	 * Configure a pre-constructed instance of LongRunningThreads resource
	 * 
	 * @parameter Instance of LongRunningThreads to configure
	 * @return nothing
	 */
	void accept(T value);

	default LongRunningThreadsConsumer<T> andThen(
			LongRunningThreadsConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}