package org.wildfly.swarm.config.jgroups.channel;

import org.wildfly.swarm.config.jgroups.channel.Fork;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ForkConsumer<T extends Fork<T>> {

	/**
	 * Configure a pre-constructed instance of Fork resource
	 * 
	 * @parameter Instance of Fork to configure
	 * @return nothing
	 */
	void accept(T value);

	default ForkConsumer<T> andThen(ForkConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}