package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A pattern formatter to be used with handlers.
 */
@Addresses({"/subsystem=logging/logging-profile=*/pattern-formatter=*",
		"/subsystem=logging/pattern-formatter=*"})
@ResourceType("pattern-formatter")
public class PatternFormatter<T extends PatternFormatter<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The color-map attribute allows for a comma delimited list of colors to be used for different levels with a pattern formatter. The format for the color mapping pattern is level-name:color-name.Valid Levels; severe, fatal, error, warn, warning, info, debug, trace, config, fine, finer, finest Valid Colors; black, green, red, yellow, blue, magenta, cyan, white, brightblack, brightred, brightgreen, brightblue, brightyellow, brightmagenta, brightcyan, brightwhite")
	private String colorMap;
	@AttributeDocumentation("Defines a pattern for the formatter.")
	private String pattern;

	public PatternFormatter(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The color-map attribute allows for a comma delimited list of colors to be
	 * used for different levels with a pattern formatter. The format for the
	 * color mapping pattern is level-name:color-name.Valid Levels; severe,
	 * fatal, error, warn, warning, info, debug, trace, config, fine, finer,
	 * finest Valid Colors; black, green, red, yellow, blue, magenta, cyan,
	 * white, brightblack, brightred, brightgreen, brightblue, brightyellow,
	 * brightmagenta, brightcyan, brightwhite
	 */
	@ModelNodeBinding(detypedName = "color-map")
	public String colorMap() {
		return this.colorMap;
	}

	/**
	 * The color-map attribute allows for a comma delimited list of colors to be
	 * used for different levels with a pattern formatter. The format for the
	 * color mapping pattern is level-name:color-name.Valid Levels; severe,
	 * fatal, error, warn, warning, info, debug, trace, config, fine, finer,
	 * finest Valid Colors; black, green, red, yellow, blue, magenta, cyan,
	 * white, brightblack, brightred, brightgreen, brightblue, brightyellow,
	 * brightmagenta, brightcyan, brightwhite
	 */
	@SuppressWarnings("unchecked")
	public T colorMap(java.lang.String value) {
		Object oldValue = this.colorMap;
		this.colorMap = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("colorMap", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines a pattern for the formatter.
	 */
	@ModelNodeBinding(detypedName = "pattern")
	public String pattern() {
		return this.pattern;
	}

	/**
	 * Defines a pattern for the formatter.
	 */
	@SuppressWarnings("unchecked")
	public T pattern(java.lang.String value) {
		Object oldValue = this.pattern;
		this.pattern = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("pattern", oldValue, value);
		return (T) this;
	}
}