package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.AuditAccess;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AuditAccessConsumer<T extends AuditAccess<T>> {

	/**
	 * Configure a pre-constructed instance of AuditAccess resource
	 * 
	 * @parameter Instance of AuditAccess to configure
	 * @return nothing
	 */
	void accept(T value);

	default AuditAccessConsumer<T> andThen(AuditAccessConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}