package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.IdentityAccess;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface IdentityAccessConsumer<T extends IdentityAccess<T>> {

	/**
	 * Configure a pre-constructed instance of IdentityAccess resource
	 * 
	 * @parameter Instance of IdentityAccess to configure
	 * @return nothing
	 */
	void accept(T value);

	default IdentityAccessConsumer<T> andThen(IdentityAccessConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}