package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.NativeInterfaceManagementInterface;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface NativeInterfaceManagementInterfaceConsumer<T extends NativeInterfaceManagementInterface<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * NativeInterfaceManagementInterface resource
	 * 
	 * @parameter Instance of NativeInterfaceManagementInterface to configure
	 * @return nothing
	 */
	void accept(T value);

	default NativeInterfaceManagementInterfaceConsumer<T> andThen(
			NativeInterfaceManagementInterfaceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}