package org.wildfly.swarm.config.management.access.constraint.application_classification.type;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesToConsumer;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesToSupplier;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesTo;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration of an application classification constraint.
 */
@Address("/core-service=management/access=authorization/constraint=application-classification/type=*/classification=*")
@ResourceType("classification")
public class Classification<T extends Classification<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ClassificationResources subresources = new ClassificationResources();
	@AttributeDocumentation("Set to override the default as to whether the constraint is considered an application resource.")
	private Boolean configuredApplication;
	@AttributeDocumentation("Whether targets having this application type constraint are considered application resources.")
	private Boolean defaultApplication;

	public Classification(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ClassificationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all AppliesTo objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AppliesTo objects.
	 */
	@SuppressWarnings("unchecked")
	public T appliesTos(java.util.List<AppliesTo> value) {
		this.subresources.appliesTos = value;
		return (T) this;
	}

	/**
	 * Add the AppliesTo object to the list of subresources
	 * 
	 * @param value
	 *            The AppliesTo to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T appliesTo(AppliesTo value) {
		this.subresources.appliesTos.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AppliesTo object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AppliesTo resource
	 * @param config
	 *            The AppliesToConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T appliesTo(java.lang.String childKey, AppliesToConsumer consumer) {
		AppliesTo<? extends AppliesTo> child = new AppliesTo<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		appliesTo(child);
		return (T) this;
	}

	/**
	 * Create and configure a AppliesTo object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AppliesTo resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T appliesTo(java.lang.String childKey) {
		appliesTo(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AppliesTo object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T appliesTo(AppliesToSupplier supplier) {
		appliesTo(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Classification
	 */
	public static class ClassificationResources {
		/**
		 * Information about the resources, attributes and operations to which
		 * an access control constraint applies.
		 */
		@ResourceDocumentation("Information about the resources, attributes and operations to which an access control constraint applies.")
		@SubresourceInfo("appliesTo")
		private List<AppliesTo> appliesTos = new java.util.ArrayList<>();

		/**
		 * Get the list of AppliesTo resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AppliesTo> appliesTos() {
			return this.appliesTos;
		}

		public AppliesTo appliesTo(java.lang.String key) {
			return this.appliesTos.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	/**
	 * Set to override the default as to whether the constraint is considered an
	 * application resource.
	 */
	@ModelNodeBinding(detypedName = "configured-application")
	public Boolean configuredApplication() {
		return this.configuredApplication;
	}

	/**
	 * Set to override the default as to whether the constraint is considered an
	 * application resource.
	 */
	@SuppressWarnings("unchecked")
	public T configuredApplication(java.lang.Boolean value) {
		Object oldValue = this.configuredApplication;
		this.configuredApplication = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("configuredApplication", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Whether targets having this application type constraint are considered
	 * application resources.
	 */
	@ModelNodeBinding(detypedName = "default-application")
	public Boolean defaultApplication() {
		return this.defaultApplication;
	}

	/**
	 * Whether targets having this application type constraint are considered
	 * application resources.
	 */
	@SuppressWarnings("unchecked")
	public T defaultApplication(java.lang.Boolean value) {
		Object oldValue = this.defaultApplication;
		this.defaultApplication = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultApplication", oldValue, value);
		return (T) this;
	}
}