package org.wildfly.swarm.config.management.access.constraint.type.classification;

import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesTo;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AppliesToConsumer<T extends AppliesTo<T>> {

	/**
	 * Configure a pre-constructed instance of AppliesTo resource
	 * 
	 * @parameter Instance of AppliesTo to configure
	 * @return nothing
	 */
	void accept(T value);

	default AppliesToConsumer<T> andThen(AppliesToConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}