package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration to use Kerberos to authenticate the users.
 */
@Address("/core-service=management/security-realm=*/authentication=kerberos")
@ResourceType("authentication")
@Implicit
public class KerberosAuthentication<T extends KerberosAuthentication<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("After authentication should the realm name be stripped from the users name.")
	private Boolean removeRealm;

	public KerberosAuthentication() {
		super();
		this.key = "kerberos";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * After authentication should the realm name be stripped from the users
	 * name.
	 */
	@ModelNodeBinding(detypedName = "remove-realm")
	public Boolean removeRealm() {
		return this.removeRealm;
	}

	/**
	 * After authentication should the realm name be stripped from the users
	 * name.
	 */
	@SuppressWarnings("unchecked")
	public T removeRealm(java.lang.Boolean value) {
		Object oldValue = this.removeRealm;
		this.removeRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("removeRealm", oldValue, value);
		return (T) this;
	}
}