package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.management.security_realm.authorization.PrincipalToGroupGroupSearch;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PrincipalToGroupGroupSearchConsumer<T extends PrincipalToGroupGroupSearch<T>> {

	/**
	 * Configure a pre-constructed instance of PrincipalToGroupGroupSearch
	 * resource
	 * 
	 * @parameter Instance of PrincipalToGroupGroupSearch to configure
	 * @return nothing
	 */
	void accept(T value);

	default PrincipalToGroupGroupSearchConsumer<T> andThen(
			PrincipalToGroupGroupSearchConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}