package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.Bridge;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface BridgeConsumer<T extends Bridge<T>> {

	/**
	 * Configure a pre-constructed instance of Bridge resource
	 * 
	 * @parameter Instance of Bridge to configure
	 * @return nothing
	 */
	void accept(T value);

	default BridgeConsumer<T> andThen(BridgeConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}