package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A messaging resource that allows you to transparently divert messages routed
 * to one address to some other address, without making any changes to any
 * client application logic.
 */
@Address("/subsystem=messaging-activemq/server=*/divert=*")
@ResourceType("divert")
public class Divert<T extends Divert<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Address to divert from")
	private String divertAddress;
	@AttributeDocumentation("Whether the divert is exclusive, meaning that the message is diverted to the new address, and does not go to the old address at all.")
	private Boolean exclusive;
	@AttributeDocumentation("An optional filter string. If specified then only messages which match the filter expression specified will be diverted. The filter string follows the ActiveMQ filter expression syntax described in the ActiveMQ documentation.")
	private String filter;
	@AttributeDocumentation("Address to divert to")
	private String forwardingAddress;
	@AttributeDocumentation("Routing name of the divert")
	private String routingName;
	@AttributeDocumentation("The name of a class used to transform the message's body or properties before it is diverted.")
	private String transformerClassName;

	public Divert(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Address to divert from
	 */
	@ModelNodeBinding(detypedName = "divert-address")
	public String divertAddress() {
		return this.divertAddress;
	}

	/**
	 * Address to divert from
	 */
	@SuppressWarnings("unchecked")
	public T divertAddress(java.lang.String value) {
		Object oldValue = this.divertAddress;
		this.divertAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("divertAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the divert is exclusive, meaning that the message is diverted to
	 * the new address, and does not go to the old address at all.
	 */
	@ModelNodeBinding(detypedName = "exclusive")
	public Boolean exclusive() {
		return this.exclusive;
	}

	/**
	 * Whether the divert is exclusive, meaning that the message is diverted to
	 * the new address, and does not go to the old address at all.
	 */
	@SuppressWarnings("unchecked")
	public T exclusive(java.lang.Boolean value) {
		Object oldValue = this.exclusive;
		this.exclusive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exclusive", oldValue, value);
		return (T) this;
	}

	/**
	 * An optional filter string. If specified then only messages which match
	 * the filter expression specified will be diverted. The filter string
	 * follows the ActiveMQ filter expression syntax described in the ActiveMQ
	 * documentation.
	 */
	@ModelNodeBinding(detypedName = "filter")
	public String filter() {
		return this.filter;
	}

	/**
	 * An optional filter string. If specified then only messages which match
	 * the filter expression specified will be diverted. The filter string
	 * follows the ActiveMQ filter expression syntax described in the ActiveMQ
	 * documentation.
	 */
	@SuppressWarnings("unchecked")
	public T filter(java.lang.String value) {
		Object oldValue = this.filter;
		this.filter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filter", oldValue, value);
		return (T) this;
	}

	/**
	 * Address to divert to
	 */
	@ModelNodeBinding(detypedName = "forwarding-address")
	public String forwardingAddress() {
		return this.forwardingAddress;
	}

	/**
	 * Address to divert to
	 */
	@SuppressWarnings("unchecked")
	public T forwardingAddress(java.lang.String value) {
		Object oldValue = this.forwardingAddress;
		this.forwardingAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("forwardingAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * Routing name of the divert
	 */
	@ModelNodeBinding(detypedName = "routing-name")
	public String routingName() {
		return this.routingName;
	}

	/**
	 * Routing name of the divert
	 */
	@SuppressWarnings("unchecked")
	public T routingName(java.lang.String value) {
		Object oldValue = this.routingName;
		this.routingName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("routingName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of a class used to transform the message's body or properties
	 * before it is diverted.
	 */
	@ModelNodeBinding(detypedName = "transformer-class-name")
	public String transformerClassName() {
		return this.transformerClassName;
	}

	/**
	 * The name of a class used to transform the message's body or properties
	 * before it is diverted.
	 */
	@SuppressWarnings("unchecked")
	public T transformerClassName(java.lang.String value) {
		Object oldValue = this.transformerClassName;
		this.transformerClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transformerClassName", oldValue, value);
		return (T) this;
	}
}