package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptor;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RemoteAcceptorConsumer<T extends RemoteAcceptor<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteAcceptor resource
	 * 
	 * @parameter Instance of RemoteAcceptor to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteAcceptorConsumer<T> andThen(RemoteAcceptorConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}