package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.Role;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RoleConsumer<T extends Role<T>> {

	/**
	 * Configure a pre-constructed instance of Role resource
	 * 
	 * @parameter Instance of Role to configure
	 * @return nothing
	 */
	void accept(T value);

	default RoleConsumer<T> andThen(RoleConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}