package org.wildfly.swarm.config.modcluster;

import org.wildfly.swarm.config.modcluster.ConfigurationModClusterConfig;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConfigurationModClusterConfigConsumer<T extends ConfigurationModClusterConfig<T>> {

	/**
	 * Configure a pre-constructed instance of ConfigurationModClusterConfig
	 * resource
	 * 
	 * @parameter Instance of ConfigurationModClusterConfig to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigurationModClusterConfigConsumer<T> andThen(
			ConfigurationModClusterConfigConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}