package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of an Elytron-compatible key manager that is exported from
 * a legacy JSSE domain.
 */
@Address("/subsystem=security/elytron-key-manager=*")
@ResourceType("elytron-key-manager")
public class ElytronKeyManager<T extends ElytronKeyManager<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the legacy security domain that contains a JSSE configuration that can be used to export the key manager.")
	private String legacyJsseConfig;

	public ElytronKeyManager(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the legacy security domain that contains a JSSE configuration
	 * that can be used to export the key manager.
	 */
	@ModelNodeBinding(detypedName = "legacy-jsse-config")
	public String legacyJsseConfig() {
		return this.legacyJsseConfig;
	}

	/**
	 * The name of the legacy security domain that contains a JSSE configuration
	 * that can be used to export the key manager.
	 */
	@SuppressWarnings("unchecked")
	public T legacyJsseConfig(java.lang.String value) {
		Object oldValue = this.legacyJsseConfig;
		this.legacyJsseConfig = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("legacyJsseConfig", oldValue, value);
		return (T) this;
	}
}