package org.wildfly.swarm.config.security.manager;

import org.wildfly.swarm.config.security.manager.DefaultDeploymentPermissions;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface DefaultDeploymentPermissionsConsumer<T extends DefaultDeploymentPermissions<T>> {

	/**
	 * Configure a pre-constructed instance of DefaultDeploymentPermissions
	 * resource
	 * 
	 * @parameter Instance of DefaultDeploymentPermissions to configure
	 * @return nothing
	 */
	void accept(T value);

	default DefaultDeploymentPermissionsConsumer<T> andThen(
			DefaultDeploymentPermissionsConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}