package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.security.security_domain.ClassicAudit;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ClassicAuditConsumer<T extends ClassicAudit<T>> {

	/**
	 * Configure a pre-constructed instance of ClassicAudit resource
	 * 
	 * @parameter Instance of ClassicAudit to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClassicAuditConsumer<T> andThen(ClassicAuditConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}