package org.wildfly.swarm.config.security.security_domain.mapping;

import org.wildfly.swarm.config.security.security_domain.mapping.MappingModule;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface MappingModuleConsumer<T extends MappingModule<T>> {

	/**
	 * Configure a pre-constructed instance of MappingModule resource
	 * 
	 * @parameter Instance of MappingModule to configure
	 * @return nothing
	 */
	void accept(T value);

	default MappingModuleConsumer<T> andThen(MappingModuleConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}