package org.wildfly.swarm.config.singleton.singleton_policy;

import org.wildfly.swarm.config.singleton.singleton_policy.RandomElectionPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RandomElectionPolicyConsumer<T extends RandomElectionPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of RandomElectionPolicy resource
	 * 
	 * @parameter Instance of RandomElectionPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default RandomElectionPolicyConsumer<T> andThen(
			RandomElectionPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}