package org.wildfly.swarm.config.transactions.log_store;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.transactions.log_store.transactions.ParticipantsConsumer;
import org.wildfly.swarm.config.transactions.log_store.transactions.ParticipantsSupplier;
import org.wildfly.swarm.config.transactions.log_store.transactions.Participants;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The persistent information that the transaction manager stores for the
 * purpose of recovering a transaction in the event of failure. The probe
 * operation will add and remove transactions from the model as the
 * corresponding real transactions start and finish the prepare and commit
 * phases. A stuck transaction will remain in the model until either it is
 * completed or explicitly removed by the delete operation.
 */
@Address("/subsystem=transactions/log-store=log-store/transactions=*")
@ResourceType("transactions")
public class Transactions<T extends Transactions<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private TransactionsResources subresources = new TransactionsResources();
	@AttributeDocumentation("The time since this transaction was prepared or when the recovery system last tried to recover it.")
	private Long ageInSeconds;
	@AttributeDocumentation("The id of this transaction.")
	private String id;
	@AttributeDocumentation("The JMX name of this transaction.")
	private String jmxName;
	@AttributeDocumentation("The type name under which this record is stored.")
	private String type;

	public Transactions(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public TransactionsResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Participants objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Participants objects.
	 */
	@SuppressWarnings("unchecked")
	public T participants(java.util.List<Participants> value) {
		this.subresources.participants = value;
		return (T) this;
	}

	/**
	 * Add the Participants object to the list of subresources
	 * 
	 * @param value
	 *            The Participants to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T participants(Participants value) {
		this.subresources.participants.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Participants object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Participants resource
	 * @param config
	 *            The ParticipantsConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T participants(java.lang.String childKey,
			ParticipantsConsumer consumer) {
		Participants<? extends Participants> child = new Participants<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		participants(child);
		return (T) this;
	}

	/**
	 * Create and configure a Participants object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Participants resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T participants(java.lang.String childKey) {
		participants(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Participants object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T participants(ParticipantsSupplier supplier) {
		participants(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Transactions
	 */
	public static class TransactionsResources {
		/**
		 * The resources that did work in a transaction.
		 */
		@ResourceDocumentation("The resources that did work in a transaction.")
		@SubresourceInfo("participants")
		private List<Participants> participants = new java.util.ArrayList<>();

		/**
		 * Get the list of Participants resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Participants> participants() {
			return this.participants;
		}

		public Participants participants(java.lang.String key) {
			return this.participants.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The time since this transaction was prepared or when the recovery system
	 * last tried to recover it.
	 */
	@ModelNodeBinding(detypedName = "age-in-seconds")
	public Long ageInSeconds() {
		return this.ageInSeconds;
	}

	/**
	 * The time since this transaction was prepared or when the recovery system
	 * last tried to recover it.
	 */
	@SuppressWarnings("unchecked")
	public T ageInSeconds(java.lang.Long value) {
		Object oldValue = this.ageInSeconds;
		this.ageInSeconds = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ageInSeconds", oldValue, value);
		return (T) this;
	}

	/**
	 * The id of this transaction.
	 */
	@ModelNodeBinding(detypedName = "id")
	public String id() {
		return this.id;
	}

	/**
	 * The id of this transaction.
	 */
	@SuppressWarnings("unchecked")
	public T id(java.lang.String value) {
		Object oldValue = this.id;
		this.id = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("id", oldValue, value);
		return (T) this;
	}

	/**
	 * The JMX name of this transaction.
	 */
	@ModelNodeBinding(detypedName = "jmx-name")
	public String jmxName() {
		return this.jmxName;
	}

	/**
	 * The JMX name of this transaction.
	 */
	@SuppressWarnings("unchecked")
	public T jmxName(java.lang.String value) {
		Object oldValue = this.jmxName;
		this.jmxName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jmxName", oldValue, value);
		return (T) this;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@SuppressWarnings("unchecked")
	public T type(java.lang.String value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}
}