package org.wildfly.swarm.config.undertow.application_security_domain;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * An SSO authentication mechanism configuration.
 */
@Address("/subsystem=undertow/application-security-domain=*/setting=single-sign-on")
@ResourceType("setting")
@Implicit
public class SingleSignOnSetting<T extends SingleSignOnSetting<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Reference to the SSL context used to secure back-channel logout connection.")
	private String clientSslContext;
	@AttributeDocumentation("Name of the cookie")
	private String cookieName;
	@AttributeDocumentation("The credential reference to decrypt the private key entry.")
	private Map credentialReference;
	@AttributeDocumentation("The cookie domain that will be used.")
	private String domain;
	@AttributeDocumentation("Set Cookie httpOnly attribute.")
	private Boolean httpOnly;
	@AttributeDocumentation("Alias of the private key entry used for signing and verifying back-channel logout connection.")
	private String keyAlias;
	@AttributeDocumentation("Reference to key store containing a private key entry.")
	private String keyStore;
	@AttributeDocumentation("Cookie path.")
	private String path;
	@AttributeDocumentation("Set Cookie secure attribute.")
	private Boolean secure;

	public SingleSignOnSetting() {
		super();
		this.key = "single-sign-on";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Reference to the SSL context used to secure back-channel logout
	 * connection.
	 */
	@ModelNodeBinding(detypedName = "client-ssl-context")
	public String clientSslContext() {
		return this.clientSslContext;
	}

	/**
	 * Reference to the SSL context used to secure back-channel logout
	 * connection.
	 */
	@SuppressWarnings("unchecked")
	public T clientSslContext(java.lang.String value) {
		Object oldValue = this.clientSslContext;
		this.clientSslContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientSslContext", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the cookie
	 */
	@ModelNodeBinding(detypedName = "cookie-name")
	public String cookieName() {
		return this.cookieName;
	}

	/**
	 * Name of the cookie
	 */
	@SuppressWarnings("unchecked")
	public T cookieName(java.lang.String value) {
		Object oldValue = this.cookieName;
		this.cookieName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cookieName", oldValue, value);
		return (T) this;
	}

	/**
	 * The credential reference to decrypt the private key entry.
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * The credential reference to decrypt the private key entry.
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * The credential reference to decrypt the private key entry.
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The cookie domain that will be used.
	 */
	@ModelNodeBinding(detypedName = "domain")
	public String domain() {
		return this.domain;
	}

	/**
	 * The cookie domain that will be used.
	 */
	@SuppressWarnings("unchecked")
	public T domain(java.lang.String value) {
		Object oldValue = this.domain;
		this.domain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("domain", oldValue, value);
		return (T) this;
	}

	/**
	 * Set Cookie httpOnly attribute.
	 */
	@ModelNodeBinding(detypedName = "http-only")
	public Boolean httpOnly() {
		return this.httpOnly;
	}

	/**
	 * Set Cookie httpOnly attribute.
	 */
	@SuppressWarnings("unchecked")
	public T httpOnly(java.lang.Boolean value) {
		Object oldValue = this.httpOnly;
		this.httpOnly = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpOnly", oldValue, value);
		return (T) this;
	}

	/**
	 * Alias of the private key entry used for signing and verifying
	 * back-channel logout connection.
	 */
	@ModelNodeBinding(detypedName = "key-alias")
	public String keyAlias() {
		return this.keyAlias;
	}

	/**
	 * Alias of the private key entry used for signing and verifying
	 * back-channel logout connection.
	 */
	@SuppressWarnings("unchecked")
	public T keyAlias(java.lang.String value) {
		Object oldValue = this.keyAlias;
		this.keyAlias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyAlias", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to key store containing a private key entry.
	 */
	@ModelNodeBinding(detypedName = "key-store")
	public String keyStore() {
		return this.keyStore;
	}

	/**
	 * Reference to key store containing a private key entry.
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(java.lang.String value) {
		Object oldValue = this.keyStore;
		this.keyStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyStore", oldValue, value);
		return (T) this;
	}

	/**
	 * Cookie path.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Cookie path.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * Set Cookie secure attribute.
	 */
	@ModelNodeBinding(detypedName = "secure")
	public Boolean secure() {
		return this.secure;
	}

	/**
	 * Set Cookie secure attribute.
	 */
	@SuppressWarnings("unchecked")
	public T secure(java.lang.Boolean value) {
		Object oldValue = this.secure;
		this.secure = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("secure", oldValue, value);
		return (T) this;
	}
}