package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.RequestLimit;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RequestLimitConsumer<T extends RequestLimit<T>> {

	/**
	 * Configure a pre-constructed instance of RequestLimit resource
	 * 
	 * @parameter Instance of RequestLimit to configure
	 * @return nothing
	 */
	void accept(T value);

	default RequestLimitConsumer<T> andThen(RequestLimitConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}