/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.PacketWritestream;
import io.vertx.core.datagram.impl.DatagramSocketImpl;

class PacketWriteStreamImpl
implements PacketWritestream,
Handler<AsyncResult<DatagramSocket>> {
    private DatagramSocketImpl datagramSocket;
    private Handler<Throwable> exceptionHandler;
    private final int port;
    private final String host;

    PacketWriteStreamImpl(DatagramSocketImpl datagramSocket, int port, String host) {
        this.datagramSocket = datagramSocket;
        this.port = port;
        this.host = host;
    }

    @Override
    public void handle(AsyncResult<DatagramSocket> event) {
        if (event.failed() && this.exceptionHandler != null) {
            this.exceptionHandler.handle(event.cause());
        }
    }

    @Override
    public PacketWritestream exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public PacketWritestream write(Buffer data) {
        this.datagramSocket.send(data, this.port, this.host, (Handler<AsyncResult<DatagramSocket>>)this);
        return this;
    }

    @Override
    public PacketWritestream setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return false;
    }

    @Override
    public PacketWritestream drainHandler(Handler<Void> handler) {
        return this;
    }
}

