/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

@VertxGen
public interface HttpServerRequest
extends ReadStream<Buffer> {
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> var1);

    public HttpServerRequest handler(Handler<Buffer> var1);

    public HttpServerRequest pause();

    public HttpServerRequest resume();

    public HttpServerRequest endHandler(Handler<Void> var1);

    public HttpVersion version();

    public HttpMethod method();

    public String uri();

    public String path();

    public String query();

    @CacheReturn
    public HttpServerResponse response();

    @CacheReturn
    public MultiMap headers();

    @CacheReturn
    public MultiMap params();

    @CacheReturn
    public SocketAddress remoteAddress();

    @CacheReturn
    public SocketAddress localAddress();

    @GenIgnore
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException;

    public String absoluteURI();

    @Fluent
    public HttpServerRequest bodyHandler(Handler<Buffer> var1);

    @CacheReturn
    public NetSocket netSocket();

    @Fluent
    public HttpServerRequest setExpectMultipart(boolean var1);

    public boolean isExpectMultipart();

    @Fluent
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> var1);

    @CacheReturn
    public MultiMap formAttributes();
}

