/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.ServerWebSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebSocketMatcher
implements Handler<ServerWebSocket> {
    private final List<PatternBinding> bindings = new ArrayList<PatternBinding>();
    private Map<String, String> params;
    private Handler<Match> handler;
    private Handler<Match> noMatchHandler;

    @Override
    public void handle(ServerWebSocket ws) {
        String path = ws.path();
        for (PatternBinding binding : this.bindings) {
            Matcher m = binding.pattern.matcher(path);
            if (!m.matches()) continue;
            this.params = new HashMap<String, String>(m.groupCount());
            if (binding.paramNames != null) {
                for (String param : binding.paramNames) {
                    this.params.put(param, m.group(param));
                }
            } else {
                for (int i = 0; i < m.groupCount(); ++i) {
                    this.params.put("param" + i, m.group(i + 1));
                }
            }
            this.handler = binding.handler;
            this.handler.handle(new Match(this.params, ws));
            this.params = null;
            this.handler = null;
            return;
        }
        if (this.noMatchHandler != null) {
            this.noMatchHandler.handle(new Match(null, ws));
        } else {
            ws.reject();
        }
    }

    public void addRegEx(String regex, Handler<Match> handler) {
        PatternBinding binding = new PatternBinding(Pattern.compile(regex), null, handler);
        this.bindings.add(binding);
    }

    public void addPattern(String pattern, Handler<Match> handler) {
        Matcher m = Pattern.compile(":([A-Za-z][A-Za-z0-9]*)").matcher(pattern);
        StringBuffer sb = new StringBuffer();
        HashSet<String> groups = new HashSet<String>();
        while (m.find()) {
            String group = m.group().substring(1);
            if (groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, "(?<$1>[^\\/]+)");
            groups.add(group);
        }
        m.appendTail(sb);
        String regex = sb.toString();
        PatternBinding binding = new PatternBinding(Pattern.compile(regex), groups, handler);
        this.bindings.add(binding);
    }

    public void noMatch(Handler<Match> handler) {
        this.noMatchHandler = handler;
    }

    public static class Match {
        public final Map<String, String> params;
        public final ServerWebSocket ws;

        public Match(Map<String, String> params, ServerWebSocket ws) {
            this.params = params;
            this.ws = ws;
        }
    }

    private static class PatternBinding {
        final Pattern pattern;
        final Handler<Match> handler;
        final Set<String> paramNames;

        private PatternBinding(Pattern pattern, Set<String> paramNames, Handler<Match> handler) {
            this.pattern = pattern;
            this.paramNames = paramNames;
            this.handler = handler;
        }
    }
}

