/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.VertxThread;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

public class BlockedThreadChecker {
    private static final Logger log = LoggerFactory.getLogger(BlockedThreadChecker.class);
    private static final Object O = new Object();
    private Map<VertxThread, Object> threads = new WeakHashMap<VertxThread, Object>();
    private final Timer timer = new Timer("vertx-blocked-thread-checker", true);

    BlockedThreadChecker(long interval, final long maxEventLoopExecTime, final long maxWorkerExecTime) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                long now = System.nanoTime();
                for (VertxThread thread : BlockedThreadChecker.this.threads.keySet()) {
                    StackTraceElement[] stack;
                    long execStart = thread.startTime();
                    long dur = now - execStart;
                    if (execStart == 0L || dur <= (thread.isWorker() ? maxWorkerExecTime : maxEventLoopExecTime)) continue;
                    log.warn("Thread " + thread + " has been blocked for " + dur / 1000000L + " ms" + " time " + maxEventLoopExecTime);
                    if (dur / 1000000L <= 5000L) continue;
                    for (StackTraceElement elem : stack = thread.getStackTrace()) {
                        System.out.println(elem);
                    }
                }
            }
        }, interval, interval);
    }

    public synchronized void registerThread(VertxThread thread) {
        this.threads.put(thread, O);
    }

    public void close() {
        this.timer.cancel();
    }
}

