/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.UUID;

public class FileResolver {
    private final Vertx vertx;
    private final boolean enableCaching = System.getProperty("vertx.disableFileCaching") == null;
    private final boolean enableCPResolving = System.getProperty("vertx.disableFileCPResolving") == null;
    private File cacheDir;

    public FileResolver(Vertx vertx) {
        this.vertx = vertx;
    }

    public void deleteCacheDir(Handler<AsyncResult<Void>> handler) {
        if (this.cacheDir != null) {
            this.vertx.fileSystem().deleteRecursive(this.cacheDir.getAbsolutePath(), true, handler);
        } else {
            handler.handle(Future.succeededFuture());
        }
    }

    public File resolveFile(String fileName) {
        File file = new File(fileName);
        if (!this.enableCPResolving) {
            return file;
        }
        if (!file.exists()) {
            File cacheFile = null;
            if (this.enableCaching && this.cacheDir != null && (cacheFile = new File(this.cacheDir, fileName)).exists()) {
                return cacheFile;
            }
            ClassLoader cl = this.getClassLoader();
            InputStream is = cl.getResourceAsStream(fileName);
            if (is != null) {
                boolean isDirectory;
                boolean bl = isDirectory = new File(fileName).getName().indexOf(46) == -1;
                if (cacheFile == null) {
                    this.setupCacheDir();
                    cacheFile = new File(this.cacheDir, fileName);
                    if (isDirectory) {
                        cacheFile.mkdirs();
                    } else {
                        cacheFile.getParentFile().mkdirs();
                    }
                }
                if (!isDirectory) {
                    try {
                        Files.copy(is, cacheFile.toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        throw new VertxException("Failed to copy file", e);
                    }
                }
                return cacheFile;
            }
        }
        return file;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }

    private void setupCacheDir() {
        if (this.cacheDir == null) {
            String cacheDirName = ".vertx/file-cache-" + UUID.randomUUID().toString();
            this.cacheDir = new File(cacheDirName);
            if (this.cacheDir.exists()) {
                this.vertx.fileSystem().deleteRecursiveBlocking(this.cacheDir.getAbsolutePath(), true);
            } else if (!this.cacheDir.mkdirs()) {
                throw new IllegalStateException("Failed to create cache dir");
            }
        }
    }
}

