/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.Options;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrustStoreOptions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;

@Options
public class CaOptions
implements TrustStoreOptions,
Cloneable {
    private ArrayList<String> certPaths;
    private ArrayList<Buffer> certValues;

    public CaOptions() {
        this.certPaths = new ArrayList();
        this.certValues = new ArrayList();
    }

    public CaOptions(CaOptions other) {
        this.certPaths = new ArrayList<String>(other.getCertPaths());
        this.certValues = new ArrayList<Buffer>(other.getCertValues());
    }

    public CaOptions(JsonObject json) {
        this.certPaths = new ArrayList();
        this.certValues = new ArrayList();
        for (Object certPath : json.getJsonArray("certPaths", new JsonArray())) {
            this.certPaths.add((String)certPath);
        }
        for (Object certValue : json.getJsonArray("certValues", new JsonArray())) {
            this.certValues.add(Buffer.buffer(Base64.getDecoder().decode((String)certValue)));
        }
    }

    public List<String> getCertPaths() {
        return this.certPaths;
    }

    public CaOptions addCertPath(String certPath) throws NullPointerException {
        Objects.requireNonNull(certPath, "No null certificate accepted");
        Arguments.require(!certPath.isEmpty(), "No empty certificate path accepted");
        this.certPaths.add(certPath);
        return this;
    }

    public List<Buffer> getCertValues() {
        return this.certValues;
    }

    public CaOptions addCertValue(Buffer certValue) throws NullPointerException {
        Objects.requireNonNull(certValue, "No null certificate accepted");
        this.certValues.add(certValue);
        return this;
    }

    @Override
    public CaOptions clone() {
        return new CaOptions(this);
    }
}

