/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.streams.Pump;

public class StreamsExamples {
    public void pump1(Vertx vertx) {
        NetServer server = vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost"));
        server.connectHandler(sock -> sock.handler(buffer -> sock.write((Buffer)buffer))).listen();
    }

    public void pump2(Vertx vertx) {
        NetServer server = vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost"));
        server.connectHandler(sock -> sock.handler(buffer -> {
            if (!sock.writeQueueFull()) {
                sock.write((Buffer)buffer);
            }
        })).listen();
    }

    public void pump3(Vertx vertx) {
        NetServer server = vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost"));
        server.connectHandler(sock -> sock.handler(buffer -> {
            sock.write((Buffer)buffer);
            if (sock.writeQueueFull()) {
                sock.pause();
            }
        })).listen();
    }

    public void pump4(Vertx vertx) {
        NetServer server = vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost"));
        server.connectHandler(sock -> sock.handler(buffer -> {
            sock.write((Buffer)buffer);
            if (sock.writeQueueFull()) {
                sock.pause();
                sock.drainHandler(done -> sock.resume());
            }
        })).listen();
    }

    public void pump5(Vertx vertx) {
        NetServer server = vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost"));
        server.connectHandler(sock -> Pump.pump(sock, sock).start()).listen();
    }
}

