/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DeploymentManager;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class HAManager {
    private static final Logger log = LoggerFactory.getLogger(HAManager.class);
    private static final String CLUSTER_MAP_NAME = "__vertx.haInfo";
    private static final long QUORUM_CHECK_PERIOD = 1000L;
    private final VertxInternal vertx;
    private final DeploymentManager deploymentManager;
    private final ClusterManager clusterManager;
    private final int quorumSize;
    private final String group;
    private final JsonObject haInfo;
    private final Map<String, String> clusterMap;
    private final String nodeID;
    private final Queue<Runnable> toDeployOnQuorum = new ConcurrentLinkedQueue<Runnable>();
    private long quorumTimerID;
    private volatile boolean attainedQuorum;
    private volatile Handler<Boolean> failoverCompleteHandler;
    private volatile boolean failDuringFailover;
    private volatile boolean stopped;
    private volatile boolean killed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HAManager(VertxInternal vertx, DeploymentManager deploymentManager, ClusterManager clusterManager, int quorumSize, String group) {
        this.vertx = vertx;
        this.deploymentManager = deploymentManager;
        this.clusterManager = clusterManager;
        this.quorumSize = quorumSize;
        this.group = group == null ? "__DEFAULT__" : group;
        this.haInfo = new JsonObject();
        this.haInfo.put("verticles", new JsonArray());
        this.haInfo.put("group", this.group);
        this.clusterMap = clusterManager.getSyncMap(CLUSTER_MAP_NAME);
        this.nodeID = clusterManager.getNodeID();
        clusterManager.nodeListener(new NodeListener(){

            @Override
            public void nodeAdded(String nodeID) {
                HAManager.this.nodeAdded(nodeID);
            }

            @Override
            public void nodeLeft(String leftNodeID) {
                HAManager.this.nodeLeft(leftNodeID);
            }
        });
        this.clusterMap.put(this.nodeID, this.haInfo.encode());
        this.quorumTimerID = vertx.setPeriodic(1000L, new Handler<Long>(){

            @Override
            public void handle(Long timerID) {
                HAManager.this.checkHADeployments();
            }
        });
        HAManager hAManager = this;
        synchronized (hAManager) {
            this.checkQuorum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromHA(String depID) {
        Deployment dep = this.deploymentManager.getDeployment(depID);
        if (dep == null || !dep.deploymentOptions().isHa()) {
            return;
        }
        JsonObject jsonObject = this.haInfo;
        synchronized (jsonObject) {
            JsonArray haMods = this.haInfo.getJsonArray("verticles");
            Iterator<Object> iter = haMods.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                JsonObject mod = (JsonObject)obj;
                if (!mod.getString("dep_id").equals(depID)) continue;
                iter.remove();
            }
            this.clusterMap.put(this.nodeID, this.haInfo.encode());
        }
    }

    public void deployVerticle(String verticleName, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> doneHandler) {
        if (this.attainedQuorum) {
            this.doDeployVerticle(verticleName, deploymentOptions, doneHandler);
        } else {
            log.info("Quorum not attained. Deployment of verticle will be delayed until there's a quorum.");
            this.addToHADeployList(verticleName, deploymentOptions, doneHandler);
        }
    }

    public void stop() {
        if (!this.stopped) {
            if (this.clusterManager.isActive()) {
                this.clusterMap.remove(this.nodeID);
            }
            this.vertx.cancelTimer(this.quorumTimerID);
            this.stopped = true;
        }
    }

    public void simulateKill() {
        if (!this.stopped) {
            this.killed = true;
            this.clusterManager.leave(ar -> {
                if (ar.failed()) {
                    log.error("Failed to leave cluster", ar.cause());
                }
            });
            this.vertx.cancelTimer(this.quorumTimerID);
            this.stopped = true;
        }
    }

    public void failoverCompleteHandler(Handler<Boolean> failoverCompleteHandler) {
        this.failoverCompleteHandler = failoverCompleteHandler;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public void failDuringFailover(boolean fail) {
        this.failDuringFailover = fail;
    }

    private void doDeployVerticle(final String verticleName, final DeploymentOptions deploymentOptions, final Handler<AsyncResult<String>> doneHandler) {
        Handler<AsyncResult<String>> wrappedHandler = new Handler<AsyncResult<String>>(){

            @Override
            public void handle(AsyncResult<String> asyncResult) {
                if (asyncResult.succeeded()) {
                    HAManager.this.addToHA(asyncResult.result(), verticleName, deploymentOptions);
                }
                if (doneHandler != null) {
                    doneHandler.handle(asyncResult);
                } else if (asyncResult.failed()) {
                    log.error("Failed to deploy verticle", asyncResult.cause());
                }
            }
        };
        this.deploymentManager.deployVerticle(verticleName, deploymentOptions, wrappedHandler);
    }

    private synchronized void nodeAdded(String nodeID) {
        this.checkQuorumWhenAdded(nodeID, System.currentTimeMillis());
    }

    private synchronized void nodeLeft(String leftNodeID) {
        this.checkQuorum();
        if (this.attainedQuorum) {
            String sclusterInfo = this.clusterMap.get(leftNodeID);
            if (sclusterInfo != null) {
                this.checkFailover(leftNodeID, new JsonObject(sclusterInfo));
            }
            List<String> nodes = this.clusterManager.getNodes();
            for (Map.Entry<String, String> entry : this.clusterMap.entrySet()) {
                if (nodes.contains(entry.getKey())) continue;
                this.checkFailover(entry.getKey(), new JsonObject(entry.getValue()));
            }
        }
    }

    private synchronized void checkQuorumWhenAdded(String nodeID, long start) {
        if (this.clusterMap.containsKey(nodeID)) {
            this.checkQuorum();
        } else {
            this.vertx.setTimer(200L, tid -> this.vertx.executeBlocking(() -> {
                if (System.currentTimeMillis() - start > 10000L) {
                    log.warn("Timed out waiting for group information to appear");
                } else if (!this.stopped) {
                    ContextImpl context = this.vertx.getContext();
                    try {
                        ContextImpl.setContext(null);
                        this.checkQuorumWhenAdded(nodeID, start);
                    }
                    finally {
                        ContextImpl.setContext(context);
                    }
                }
                return null;
            }, null));
        }
    }

    private void checkQuorum() {
        boolean attained;
        List<String> nodes = this.clusterManager.getNodes();
        int count = 0;
        for (String node : nodes) {
            JsonObject clusterInfo;
            String group;
            String json = this.clusterMap.get(node);
            if (json == null || !(group = (clusterInfo = new JsonObject(json)).getString("group")).equals(this.group)) continue;
            ++count;
        }
        boolean bl = attained = count >= this.quorumSize;
        if (!this.attainedQuorum && attained) {
            log.info("A quorum has been obtained. Any deployments waiting on a quorum will now be deployed");
            this.attainedQuorum = true;
        } else if (this.attainedQuorum && !attained) {
            log.info("There is no longer a quorum. Any HA deployments will be undeployed until a quorum is re-attained");
            this.attainedQuorum = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToHA(String deploymentID, String verticleName, DeploymentOptions deploymentOptions) {
        JsonObject jsonObject = this.haInfo;
        synchronized (jsonObject) {
            JsonObject verticleConf = new JsonObject().put("dep_id", deploymentID);
            verticleConf.put("verticle_name", verticleName);
            verticleConf.put("options", deploymentOptions.toJson());
            JsonArray haMods = this.haInfo.getJsonArray("verticles");
            haMods.add(verticleConf);
            String encoded = this.haInfo.encode();
            this.clusterMap.put(this.nodeID, encoded);
        }
    }

    private void addToHADeployList(String verticleName, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> doneHandler) {
        this.toDeployOnQuorum.add(() -> {
            ContextImpl ctx = this.vertx.getContext();
            try {
                ContextImpl.setContext(null);
                this.deployVerticle(verticleName, deploymentOptions, doneHandler);
            }
            finally {
                ContextImpl.setContext(ctx);
            }
        });
    }

    private void checkHADeployments() {
        try {
            if (this.attainedQuorum) {
                this.deployHADeployments();
            } else {
                this.undeployHADeployments();
            }
        }
        catch (Throwable t) {
            log.error("Failed when checking HA deployments", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployHADeployments() {
        for (final String deploymentID : this.deploymentManager.deployments()) {
            final Deployment dep = this.deploymentManager.getDeployment(deploymentID);
            if (dep == null || !dep.deploymentOptions().isHa()) continue;
            ContextImpl ctx = this.vertx.getContext();
            try {
                ContextImpl.setContext(null);
                this.deploymentManager.undeployVerticle(deploymentID, (Handler<AsyncResult<Void>>)new AsyncResultHandler<Void>(){

                    @Override
                    public void handle(AsyncResult<Void> result) {
                        if (result.succeeded()) {
                            log.info("Successfully undeployed HA deployment " + deploymentID + "-" + dep.verticleIdentifier() + " as there is no quorum");
                            HAManager.this.addToHADeployList(dep.verticleIdentifier(), dep.deploymentOptions(), new AsyncResultHandler<String>(){

                                @Override
                                public void handle(AsyncResult<String> result) {
                                    if (result.succeeded()) {
                                        log.info("Successfully redeployed verticle " + dep.verticleIdentifier() + " after quorum was re-attained");
                                    } else {
                                        log.error("Failed to redeploy verticle " + dep.verticleIdentifier() + " after quorum was re-attained", result.cause());
                                    }
                                }
                            });
                        } else {
                            log.error("Failed to undeploy deployment on lost quorum", result.cause());
                        }
                    }
                });
            }
            finally {
                ContextImpl.setContext(ctx);
            }
        }
    }

    private void deployHADeployments() {
        int size = this.toDeployOnQuorum.size();
        if (size != 0) {
            Runnable task;
            log.info("There are " + size + " HA deployments waiting on a quorum. These will now be deployed");
            while ((task = this.toDeployOnQuorum.poll()) != null) {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    log.error("Failed to run redeployment task", t);
                }
            }
        }
    }

    private void checkFailover(String failedNodeID, JsonObject theHAInfo) {
        try {
            JsonArray deployments = theHAInfo.getJsonArray("verticles");
            String group = theHAInfo.getString("group");
            String chosen = this.chooseHashedNode(group, failedNodeID.hashCode());
            if (chosen != null && chosen.equals(this.nodeID)) {
                if (deployments != null) {
                    log.info("Node " + failedNodeID + " has failed. This node will deploy " + deployments.size() + " deployments from that node.");
                    for (Object obj : deployments) {
                        JsonObject app = (JsonObject)obj;
                        this.processFailover(app);
                    }
                }
                this.clusterMap.remove(failedNodeID);
                this.callFailoverCompleteHandler(true);
            }
        }
        catch (Throwable t) {
            log.error("Failed to handle failover", t);
            this.callFailoverCompleteHandler(false);
        }
    }

    private void callFailoverCompleteHandler(boolean result) {
        if (this.failoverCompleteHandler != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.vertx.runOnContext(v -> {
                this.failoverCompleteHandler.handle(result);
                latch.countDown();
            });
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void processFailover(JsonObject failedVerticle) {
        if (this.failDuringFailover) {
            throw new VertxException("Oops!");
        }
        String verticleName = failedVerticle.getString("verticle_name");
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference err = new AtomicReference();
        ContextImpl ctx = this.vertx.getContext();
        ContextImpl.setContext(null);
        JsonObject options = failedVerticle.getJsonObject("options");
        this.doDeployVerticle(verticleName, new DeploymentOptions(options), result -> {
            if (result.succeeded()) {
                log.info("Successfully redeployed verticle " + verticleName + " after failover");
            } else {
                log.error("Failed to redeploy verticle after failover", result.cause());
                err.set(result.cause());
            }
            latch.countDown();
            Throwable t = (Throwable)err.get();
            if (t != null) {
                throw new VertxException(t);
            }
        });
        ContextImpl.setContext(ctx);
        try {
            if (!latch.await(120L, TimeUnit.SECONDS)) {
                throw new VertxException("Timed out waiting for redeploy on failover");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private String chooseHashedNode(String group, int hashCode) {
        List<String> nodes = this.clusterManager.getNodes();
        ArrayList<String> matchingMembers = new ArrayList<String>();
        for (String node : nodes) {
            JsonObject clusterInfo;
            String memberGroup;
            String sclusterInfo = this.clusterMap.get(node);
            if (sclusterInfo == null || !group.equals(memberGroup = (clusterInfo = new JsonObject(sclusterInfo)).getString("group"))) continue;
            matchingMembers.add(node);
        }
        if (!matchingMembers.isEmpty()) {
            long absHash = (long)hashCode + Integer.MAX_VALUE;
            long lpos = absHash % (long)matchingMembers.size();
            return (String)matchingMembers.get((int)lpos);
        }
        return null;
    }
}

