/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.spi.cluster.Action;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Redeployer
implements Action<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(Redeployer.class);
    private final long gracePeriod;
    private final Map<File, Map<File, FileInfo>> fileMap = new HashMap<File, Map<File, FileInfo>>();
    private final Set<File> filesToWatch = new HashSet<File>();
    private long lastChange = -1L;

    public Redeployer(Set<File> files, long gracePeriod) {
        this.gracePeriod = gracePeriod;
        for (File file : files) {
            this.addFileToWatch(file);
        }
    }

    private void addFileToWatch(File file) {
        this.filesToWatch.add(file);
        HashMap<File, FileInfo> map = new HashMap<File, FileInfo>();
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    map.put(child, new FileInfo(child.lastModified(), child.length()));
                    if (!child.isDirectory()) continue;
                    this.addFileToWatch(child);
                }
            }
        } else {
            map.put(file, new FileInfo(file.lastModified(), file.length()));
        }
        this.fileMap.put(file, map);
    }

    private boolean changesHaveOccurred() {
        boolean changed = false;
        for (File toWatch : new HashSet<File>(this.filesToWatch)) {
            HashMap<File, File> newFiles = new HashMap<File, File>();
            if (toWatch.isDirectory()) {
                File[] files = toWatch.exists() ? toWatch.listFiles() : new File[]{};
                for (File file : files) {
                    newFiles.put(file, file);
                }
            } else {
                newFiles.put(toWatch, toWatch);
            }
            Map<File, FileInfo> currentFileMap = this.fileMap.get(toWatch);
            for (Map.Entry entry : new HashMap<File, FileInfo>(currentFileMap).entrySet()) {
                File currFile = (File)entry.getKey();
                FileInfo currInfo = (FileInfo)entry.getValue();
                File newFile = (File)newFiles.get(currFile);
                if (newFile == null) {
                    currentFileMap.remove(currFile);
                    if (currentFileMap.isEmpty()) {
                        this.fileMap.remove(toWatch);
                        this.filesToWatch.remove(toWatch);
                    }
                    log.trace("File: " + currFile + " has been deleted");
                    changed = true;
                    continue;
                }
                if (newFile.lastModified() == currInfo.lastModified && newFile.length() == currInfo.length) continue;
                currentFileMap.put(newFile, new FileInfo(newFile.lastModified(), newFile.length()));
                log.trace("File: " + currFile + " has been modified");
                changed = true;
            }
            for (File file : newFiles.keySet()) {
                if (currentFileMap.containsKey(file)) continue;
                currentFileMap.put(file, new FileInfo(file.lastModified(), file.length()));
                if (file.isDirectory()) {
                    this.addFileToWatch(file);
                }
                log.trace("File was added: " + file);
                changed = true;
            }
        }
        long now = System.currentTimeMillis();
        if (changed) {
            this.lastChange = now;
        }
        if (this.lastChange != -1L && now - this.lastChange >= this.gracePeriod) {
            this.lastChange = -1L;
            return true;
        }
        return false;
    }

    @Override
    public Boolean perform() {
        return this.changesHaveOccurred();
    }

    private static final class FileInfo {
        long lastModified;
        long length;

        private FileInfo(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }
    }
}

