/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.CaOptions;
import io.vertx.core.net.JKSOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.NetworkOptions;
import io.vertx.core.net.PKCS12Options;
import io.vertx.core.net.TrustStoreOptions;
import io.vertx.core.net.impl.SocketDefaults;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class TCPSSLOptions
extends NetworkOptions {
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = SocketDefaults.instance.isTcpKeepAlive();
    public static final int DEFAULT_SO_LINGER = SocketDefaults.instance.getSoLinger();
    public static final boolean DEFAULT_USE_POOLED_BUFFERS = false;
    public static final boolean DEFAULT_SSL = false;
    public static final int DEFAULT_IDLE_TIMEOUT = 0;
    private boolean tcpNoDelay;
    private boolean tcpKeepAlive;
    private int soLinger;
    private boolean usePooledBuffers;
    private int idleTimeout;
    private boolean ssl;
    private KeyStoreOptions keyStore;
    private TrustStoreOptions trustStore;
    private Set<String> enabledCipherSuites = new HashSet<String>();
    private ArrayList<String> crlPaths;
    private ArrayList<Buffer> crlValues;

    public TCPSSLOptions(TCPSSLOptions other) {
        super(other);
        this.tcpNoDelay = other.isTcpNoDelay();
        this.tcpKeepAlive = other.isTcpKeepAlive();
        this.soLinger = other.getSoLinger();
        this.usePooledBuffers = other.isUsePooledBuffers();
        this.idleTimeout = other.getIdleTimeout();
        this.ssl = other.isSsl();
        this.keyStore = other.getKeyStoreOptions() != null ? other.getKeyStoreOptions().clone() : null;
        this.trustStore = other.getTrustStoreOptions() != null ? other.getTrustStoreOptions().clone() : null;
        this.enabledCipherSuites = other.getEnabledCipherSuites() == null ? null : new HashSet<String>(other.getEnabledCipherSuites());
        this.crlPaths = new ArrayList<String>(other.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(other.getCrlValues());
    }

    public TCPSSLOptions(JsonObject json) {
        super(json);
        JsonArray arr;
        JsonObject trustStoreJson;
        this.tcpNoDelay = json.getBoolean("tcpNoDelay", true);
        this.tcpKeepAlive = json.getBoolean("tcpKeepAlive", DEFAULT_TCP_KEEP_ALIVE);
        this.soLinger = json.getInteger("soLinger", DEFAULT_SO_LINGER);
        this.usePooledBuffers = json.getBoolean("usePooledBuffers", false);
        this.idleTimeout = json.getInteger("idleTimeout", 0);
        this.ssl = json.getBoolean("ssl", false);
        JsonObject keyStoreJson = json.getJsonObject("keyStoreOptions");
        if (keyStoreJson != null) {
            String type = keyStoreJson.getString("type", null);
            switch (type != null ? type.toLowerCase() : "jks") {
                case "jks": {
                    this.keyStore = new JKSOptions(keyStoreJson);
                    break;
                }
                case "pkcs12": {
                    this.keyStore = new PKCS12Options(keyStoreJson);
                    break;
                }
                case "keycert": {
                    this.keyStore = new KeyCertOptions(keyStoreJson);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid key store type: " + type);
                }
            }
        }
        if ((trustStoreJson = json.getJsonObject("trustStoreOptions")) != null) {
            String type = trustStoreJson.getString("type", null);
            switch (type != null ? type.toLowerCase() : "jks") {
                case "jks": {
                    this.trustStore = new JKSOptions(trustStoreJson);
                    break;
                }
                case "pkcs12": {
                    this.trustStore = new PKCS12Options(trustStoreJson);
                    break;
                }
                case "ca": {
                    this.trustStore = new CaOptions(trustStoreJson);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid trust store type: " + type);
                }
            }
        }
        this.enabledCipherSuites = (arr = json.getJsonArray("enabledCipherSuites")) == null ? null : new HashSet(arr.getList());
        arr = json.getJsonArray("crlPaths");
        this.crlPaths = arr == null ? new ArrayList() : new ArrayList(arr.getList());
        this.crlValues = new ArrayList();
        arr = json.getJsonArray("crlValues");
        if (arr != null) {
            arr.getList().stream().map(Buffer::buffer).forEach(this.crlValues::add);
        }
    }

    public TCPSSLOptions() {
        this.tcpNoDelay = true;
        this.tcpKeepAlive = DEFAULT_TCP_KEEP_ALIVE;
        this.soLinger = DEFAULT_SO_LINGER;
        this.usePooledBuffers = false;
        this.idleTimeout = 0;
        this.ssl = false;
        this.crlPaths = new ArrayList();
        this.crlValues = new ArrayList();
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public TCPSSLOptions setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public TCPSSLOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
        return this;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public TCPSSLOptions setSoLinger(int soLinger) {
        if (soLinger < 0) {
            throw new IllegalArgumentException("soLinger must be >= 0");
        }
        this.soLinger = soLinger;
        return this;
    }

    public boolean isUsePooledBuffers() {
        return this.usePooledBuffers;
    }

    public TCPSSLOptions setUsePooledBuffers(boolean usePooledBuffers) {
        this.usePooledBuffers = usePooledBuffers;
        return this;
    }

    public TCPSSLOptions setIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("idleTimeout must be >= 0");
        }
        this.idleTimeout = idleTimeout;
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public TCPSSLOptions setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public KeyStoreOptions getKeyStoreOptions() {
        return this.keyStore;
    }

    public TCPSSLOptions setKeyStoreOptions(KeyStoreOptions keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public TrustStoreOptions getTrustStoreOptions() {
        return this.trustStore;
    }

    public TCPSSLOptions setTrustStoreOptions(TrustStoreOptions trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public TCPSSLOptions addEnabledCipherSuite(String suite) {
        this.enabledCipherSuites.add(suite);
        return this;
    }

    public Set<String> getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public List<String> getCrlPaths() {
        return this.crlPaths;
    }

    public TCPSSLOptions addCrlPath(String crlPath) throws NullPointerException {
        Objects.requireNonNull(crlPath, "No null crl accepted");
        this.crlPaths.add(crlPath);
        return this;
    }

    public List<Buffer> getCrlValues() {
        return this.crlValues;
    }

    public TCPSSLOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        Objects.requireNonNull(crlValue, "No null crl accepted");
        this.crlValues.add(crlValue);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TCPSSLOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TCPSSLOptions that = (TCPSSLOptions)o;
        if (this.idleTimeout != that.idleTimeout) {
            return false;
        }
        if (this.soLinger != that.soLinger) {
            return false;
        }
        if (this.ssl != that.ssl) {
            return false;
        }
        if (this.tcpKeepAlive != that.tcpKeepAlive) {
            return false;
        }
        if (this.tcpNoDelay != that.tcpNoDelay) {
            return false;
        }
        if (this.usePooledBuffers != that.usePooledBuffers) {
            return false;
        }
        if (this.crlPaths != null ? !this.crlPaths.equals(that.crlPaths) : that.crlPaths != null) {
            return false;
        }
        if (this.crlValues != null ? !this.crlValues.equals(that.crlValues) : that.crlValues != null) {
            return false;
        }
        if (this.enabledCipherSuites != null ? !this.enabledCipherSuites.equals(that.enabledCipherSuites) : that.enabledCipherSuites != null) {
            return false;
        }
        if (this.keyStore != null ? !this.keyStore.equals(that.keyStore) : that.keyStore != null) {
            return false;
        }
        return !(this.trustStore != null ? !this.trustStore.equals(that.trustStore) : that.trustStore != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tcpNoDelay ? 1 : 0);
        result = 31 * result + (this.tcpKeepAlive ? 1 : 0);
        result = 31 * result + this.soLinger;
        result = 31 * result + (this.usePooledBuffers ? 1 : 0);
        result = 31 * result + this.idleTimeout;
        result = 31 * result + (this.ssl ? 1 : 0);
        result = 31 * result + (this.keyStore != null ? this.keyStore.hashCode() : 0);
        result = 31 * result + (this.trustStore != null ? this.trustStore.hashCode() : 0);
        result = 31 * result + (this.enabledCipherSuites != null ? this.enabledCipherSuites.hashCode() : 0);
        result = 31 * result + (this.crlPaths != null ? this.crlPaths.hashCode() : 0);
        result = 31 * result + (this.crlValues != null ? this.crlValues.hashCode() : 0);
        return result;
    }
}

