/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.buffer;

import io.netty.buffer.ByteBuf;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.ServiceHelper;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.core.spi.BufferFactory;
import java.nio.ByteBuffer;

@VertxGen
public interface Buffer
extends ClusterSerializable {
    public static final BufferFactory factory = ServiceHelper.loadFactory(BufferFactory.class);

    public static Buffer buffer() {
        return factory.buffer();
    }

    public static Buffer buffer(int initialSizeHint) {
        return factory.buffer(initialSizeHint);
    }

    public static Buffer buffer(String string) {
        return factory.buffer(string);
    }

    public static Buffer buffer(String string, String enc) {
        return factory.buffer(string, enc);
    }

    @GenIgnore
    public static Buffer buffer(byte[] bytes) {
        return factory.buffer(bytes);
    }

    @GenIgnore
    public static Buffer buffer(ByteBuf byteBuf) {
        return factory.buffer(byteBuf);
    }

    public String toString(String var1);

    public byte getByte(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public double getDouble(int var1);

    public float getFloat(int var1);

    public short getShort(int var1);

    @GenIgnore
    public byte[] getBytes();

    @GenIgnore
    public byte[] getBytes(int var1, int var2);

    public Buffer getBuffer(int var1, int var2);

    public String getString(int var1, int var2, String var3);

    public String getString(int var1, int var2);

    @Fluent
    public Buffer appendBuffer(Buffer var1);

    @Fluent
    public Buffer appendBuffer(Buffer var1, int var2, int var3);

    @GenIgnore
    @Fluent
    public Buffer appendBytes(byte[] var1);

    @GenIgnore
    @Fluent
    public Buffer appendBytes(byte[] var1, int var2, int var3);

    @Fluent
    public Buffer appendByte(byte var1);

    @Fluent
    public Buffer appendInt(int var1);

    @Fluent
    public Buffer appendLong(long var1);

    @Fluent
    public Buffer appendShort(short var1);

    @Fluent
    public Buffer appendFloat(float var1);

    @Fluent
    public Buffer appendDouble(double var1);

    @Fluent
    public Buffer appendString(String var1, String var2);

    @Fluent
    public Buffer appendString(String var1);

    @Fluent
    public Buffer setByte(int var1, byte var2);

    @Fluent
    public Buffer setInt(int var1, int var2);

    @Fluent
    public Buffer setLong(int var1, long var2);

    @Fluent
    public Buffer setDouble(int var1, double var2);

    @Fluent
    public Buffer setFloat(int var1, float var2);

    @Fluent
    public Buffer setShort(int var1, short var2);

    @Fluent
    public Buffer setBuffer(int var1, Buffer var2);

    @Fluent
    public Buffer setBuffer(int var1, Buffer var2, int var3, int var4);

    @GenIgnore
    @Fluent
    public Buffer setBytes(int var1, ByteBuffer var2);

    @GenIgnore
    @Fluent
    public Buffer setBytes(int var1, byte[] var2);

    @GenIgnore
    @Fluent
    public Buffer setBytes(int var1, byte[] var2, int var3, int var4);

    @Fluent
    public Buffer setString(int var1, String var2);

    @Fluent
    public Buffer setString(int var1, String var2, String var3);

    public int length();

    public Buffer copy();

    public Buffer slice();

    public Buffer slice(int var1, int var2);

    @GenIgnore
    public ByteBuf getByteBuf();
}

