/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.netty.util.CharsetUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.ServerID;
import java.util.List;
import java.util.Map;

public class MessageImpl<U, V>
implements Message<V> {
    private static final Logger log = LoggerFactory.getLogger(MessageImpl.class);
    private static final byte WIRE_PROTOCOL_VERSION = 1;
    private NetSocket socket;
    private EventBusImpl bus;
    private ServerID sender;
    private String address;
    private String replyAddress;
    private MultiMap headers;
    private U sentBody;
    private V receivedBody;
    private MessageCodec<U, V> messageCodec;
    private boolean send;
    private Buffer wireBuffer;
    private int bodyPos;
    private int headersPos;

    public MessageImpl() {
    }

    public MessageImpl(ServerID sender, String address, String replyAddress, MultiMap headers, U sentBody, MessageCodec<U, V> messageCodec, boolean send) {
        this.sender = sender;
        this.address = address;
        this.replyAddress = replyAddress;
        this.headers = headers;
        this.sentBody = sentBody;
        this.messageCodec = messageCodec;
        this.send = send;
    }

    private MessageImpl(MessageImpl<U, V> other) {
        this.socket = other.socket;
        this.bus = other.bus;
        this.sender = other.sender;
        this.address = other.address;
        this.replyAddress = other.replyAddress;
        this.messageCodec = other.messageCodec;
        if (other.headers != null) {
            List<Map.Entry<String, String>> entries = other.headers.entries();
            this.headers = new CaseInsensitiveHeaders();
            for (Map.Entry<String, String> entry : entries) {
                this.headers.add(entry.getKey(), entry.getValue());
            }
        }
        if (other.sentBody != null) {
            this.sentBody = other.sentBody;
            this.receivedBody = this.messageCodec.transform(other.sentBody);
        } else {
            this.wireBuffer = other.wireBuffer;
            this.bodyPos = other.bodyPos;
            this.headersPos = other.headersPos;
        }
        this.send = other.send;
    }

    NetSocket getSocket() {
        return this.socket;
    }

    public MessageImpl<U, V> copyBeforeReceive() {
        return new MessageImpl<U, V>(this);
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            if (this.headersPos != 0) {
                this.decodeHeaders();
            }
            if (this.headers == null) {
                this.headers = new CaseInsensitiveHeaders();
            }
        }
        return this.headers;
    }

    @Override
    public V body() {
        if (this.receivedBody == null && this.bodyPos != 0) {
            this.decodeBody();
        }
        return this.receivedBody;
    }

    @Override
    public String replyAddress() {
        return this.replyAddress;
    }

    public Buffer encodeToWire() {
        int length = 1024;
        Buffer buffer = Buffer.buffer(length);
        buffer.appendInt(0);
        buffer.appendByte((byte)1);
        byte systemCodecID = this.messageCodec.systemCodecID();
        buffer.appendByte(systemCodecID);
        if (systemCodecID == -1) {
            this.writeString(buffer, this.messageCodec.name());
        }
        buffer.appendByte(this.send ? (byte)0 : 1);
        this.writeString(buffer, this.address);
        if (this.replyAddress != null) {
            this.writeString(buffer, this.replyAddress);
        } else {
            buffer.appendInt(0);
        }
        buffer.appendInt(this.sender.port);
        this.writeString(buffer, this.sender.host);
        this.encodeHeaders(buffer);
        this.writeBody(buffer);
        buffer.setInt(0, buffer.length() - 4);
        return buffer;
    }

    public void readFromWire(NetSocket socket, Buffer buffer, Map<String, MessageCodec> codecMap, MessageCodec[] systemCodecs) {
        int pos = 0;
        byte protocolVersion = buffer.getByte(pos);
        if (protocolVersion > 1) {
            throw new IllegalStateException("Invalid wire protocol version " + protocolVersion + " should be <= " + 1);
        }
        byte systemCodecCode = buffer.getByte(++pos);
        ++pos;
        if (systemCodecCode == -1) {
            int length = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + length);
            String codecName = new String(bytes, CharsetUtil.UTF_8);
            this.messageCodec = codecMap.get(codecName);
            if (this.messageCodec == null) {
                throw new IllegalStateException("No message codec registered with name " + codecName);
            }
            pos += length;
        } else {
            this.messageCodec = systemCodecs[systemCodecCode];
        }
        byte bsend = buffer.getByte(pos);
        this.send = bsend == 0;
        int length = buffer.getInt(++pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + length);
        this.address = new String(bytes, CharsetUtil.UTF_8);
        pos += length;
        length = buffer.getInt(pos);
        pos += 4;
        if (length != 0) {
            bytes = buffer.getBytes(pos, pos + length);
            this.replyAddress = new String(bytes, CharsetUtil.UTF_8);
            pos += length;
        }
        int senderPort = buffer.getInt(pos);
        length = buffer.getInt(pos += 4);
        bytes = buffer.getBytes(pos += 4, pos + length);
        String senderHost = new String(bytes, CharsetUtil.UTF_8);
        this.headersPos = pos += length;
        int headersLength = buffer.getInt(pos);
        this.bodyPos = pos += headersLength;
        this.sender = new ServerID(senderPort, senderHost);
        this.wireBuffer = buffer;
        this.socket = socket;
    }

    private void decodeBody() {
        this.receivedBody = this.messageCodec.decodeFromWire(this.bodyPos, this.wireBuffer);
        this.bodyPos = 0;
    }

    private void encodeHeaders(Buffer buffer) {
        if (this.headers != null && !this.headers.isEmpty()) {
            int headersLengthPos = buffer.length();
            buffer.appendInt(0);
            buffer.appendInt(this.headers.size());
            List<Map.Entry<String, String>> entries = this.headers.entries();
            for (Map.Entry<String, String> entry : entries) {
                this.writeString(buffer, entry.getKey());
                this.writeString(buffer, entry.getValue());
            }
            int headersEndPos = buffer.length();
            buffer.setInt(headersLengthPos, headersEndPos - headersLengthPos);
        } else {
            buffer.appendInt(4);
        }
    }

    private void decodeHeaders() {
        int length = this.wireBuffer.getInt(this.headersPos);
        if (length != 0) {
            this.headersPos += 4;
            int numHeaders = this.wireBuffer.getInt(this.headersPos);
            this.headersPos += 4;
            this.headers = new CaseInsensitiveHeaders();
            for (int i = 0; i < numHeaders; ++i) {
                int keyLength = this.wireBuffer.getInt(this.headersPos);
                this.headersPos += 4;
                byte[] bytes = this.wireBuffer.getBytes(this.headersPos, this.headersPos + keyLength);
                String key = new String(bytes, CharsetUtil.UTF_8);
                this.headersPos += keyLength;
                int valLength = this.wireBuffer.getInt(this.headersPos);
                this.headersPos += 4;
                bytes = this.wireBuffer.getBytes(this.headersPos, this.headersPos + valLength);
                String val = new String(bytes, CharsetUtil.UTF_8);
                this.headersPos += valLength;
                this.headers.add(key, val);
            }
        }
        this.headersPos = 0;
    }

    private void writeBody(Buffer buff) {
        this.messageCodec.encodeToWire(buff, this.sentBody);
    }

    private void writeString(Buffer buff, String str) {
        byte[] strBytes = str.getBytes(CharsetUtil.UTF_8);
        buff.appendInt(strBytes.length);
        buff.appendBytes(strBytes);
    }

    @Override
    public void fail(int failureCode, String message) {
        if (this.replyAddress != null) {
            this.sendReply(this.bus.createMessage(true, this.replyAddress, null, new ReplyException(ReplyFailure.RECIPIENT_FAILURE, failureCode, message), null), null, null);
        }
    }

    @Override
    public void reply(Object message) {
        this.reply(message, new DeliveryOptions(), null);
    }

    @Override
    public <R> void reply(Object message, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.reply(message, new DeliveryOptions(), replyHandler);
    }

    @Override
    public void reply(Object message, DeliveryOptions options) {
        this.reply(message, options, null);
    }

    @Override
    public <R> void reply(Object message, DeliveryOptions options, Handler<AsyncResult<Message<R>>> replyHandler) {
        if (this.replyAddress != null) {
            this.sendReply(this.bus.createMessage(true, this.replyAddress, options.getHeaders(), message, options.getCodecName()), options, replyHandler);
        }
    }

    protected void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
    }

    protected boolean send() {
        return this.send;
    }

    protected void setBus(EventBusImpl eventBus) {
        this.bus = eventBus;
    }

    protected MessageCodec codec() {
        return this.messageCodec;
    }

    private <R> void sendReply(MessageImpl msg, DeliveryOptions options, Handler<AsyncResult<Message<R>>> replyHandler) {
        if (this.bus != null && this.replyAddress != null) {
            this.bus.sendReply(this.sender, msg, options, replyHandler);
        }
    }
}

