/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class EventLoopContext
extends ContextImpl {
    private static final Logger log = LoggerFactory.getLogger(EventLoopContext.class);
    private Map<String, Object> contextData;

    public EventLoopContext(VertxInternal vertx, Executor internalBlockingExec, Executor workerExec, String deploymentID, JsonObject config, ClassLoader tccl) {
        super(vertx, internalBlockingExec, workerExec, deploymentID, config, tccl);
    }

    @Override
    public void executeAsync(Handler<Void> task) {
        this.getEventLoop().execute(this.wrapTask(null, task, true));
    }

    @Override
    public boolean isEventLoopContext() {
        return true;
    }

    @Override
    public boolean isMultiThreaded() {
        return false;
    }

    @Override
    protected void checkCorrectThread() {
        Thread current = Thread.currentThread();
        if (!(current instanceof VertxThread)) {
            throw new IllegalStateException("Expected to be on Vert.x thread, but actually on: " + current);
        }
        if (this.contextThread != null && current != this.contextThread) {
            throw new IllegalStateException("Event delivered on unexpected thread " + current + " expected: " + this.contextThread);
        }
    }

    @Override
    public Map<String, Object> contextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }
}

