/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class HandlerManager<T> {
    private static final Logger log = LoggerFactory.getLogger(HandlerManager.class);
    private final VertxEventLoopGroup availableWorkers;
    private final ConcurrentMap<EventLoop, Handlers<T>> handlerMap = new ConcurrentHashMap<EventLoop, Handlers<T>>();
    private volatile boolean hasHandlers;

    public HandlerManager(VertxEventLoopGroup availableWorkers) {
        this.availableWorkers = availableWorkers;
    }

    public boolean hasHandlers() {
        return this.hasHandlers;
    }

    public HandlerHolder<T> chooseHandler(EventLoop worker) {
        Handlers handlers = (Handlers)this.handlerMap.get(worker);
        return handlers == null ? null : handlers.chooseHandler();
    }

    public synchronized void addHandler(Handler<T> handler, ContextImpl context) {
        EventLoop worker = context.eventLoop();
        this.availableWorkers.addWorker(worker);
        Handlers<T> handlers = new Handlers<T>();
        Handlers prev = this.handlerMap.putIfAbsent(worker, handlers);
        if (prev != null) {
            handlers = prev;
        }
        handlers.addHandler(new HandlerHolder<T>(context, handler));
        this.hasHandlers = true;
    }

    public synchronized void removeHandler(Handler<T> handler, ContextImpl context) {
        EventLoop worker = context.eventLoop();
        Handlers handlers = (Handlers)this.handlerMap.get(worker);
        if (!handlers.removeHandler(new HandlerHolder<T>(context, handler))) {
            throw new IllegalStateException("Can't find handler");
        }
        if (handlers.isEmpty()) {
            this.handlerMap.remove(worker);
        }
        if (handlers.isEmpty()) {
            this.hasHandlers = false;
        }
        this.availableWorkers.removeWorker(worker);
    }

    private static final class Handlers<T> {
        private int pos;
        private final List<HandlerHolder<T>> list = new CopyOnWriteArrayList<HandlerHolder<T>>();

        private Handlers() {
        }

        HandlerHolder<T> chooseHandler() {
            HandlerHolder<T> handler = this.list.get(this.pos);
            ++this.pos;
            this.checkPos();
            return handler;
        }

        void addHandler(HandlerHolder<T> handler) {
            this.list.add(handler);
        }

        boolean removeHandler(HandlerHolder<T> handler) {
            if (this.list.remove(handler)) {
                this.checkPos();
                return true;
            }
            return false;
        }

        boolean isEmpty() {
            return this.list.isEmpty();
        }

        void checkPos() {
            if (this.pos == this.list.size()) {
                this.pos = 0;
            }
        }
    }
}

