/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.spi.json.JsonCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

class JsonCodecMapper {
    private static final Map<Class, JsonCodec> codecMap;

    JsonCodecMapper() {
    }

    private static <T> JsonCodec codec(Class<T> c) {
        return codecMap.get(c);
    }

    public static <T> T decode(Object json, Class<T> c) {
        if (json == null) {
            return null;
        }
        JsonCodec codec = codecMap.get(c);
        if (codec == null) {
            throw new IllegalStateException("Unable to find codec for class " + c.getName());
        }
        return codec.decode(json);
    }

    public static <T> T decodeBuffer(Buffer value, Class<T> c) {
        return JsonCodecMapper.decode(Json.decodeValue(value), c);
    }

    public static Object encode(Object value) {
        if (value == null) {
            return null;
        }
        JsonCodec codec = codecMap.get(value.getClass());
        if (codec == null) {
            throw new IllegalStateException("Unable to find codec for class " + value.getClass().getName());
        }
        return codec.encode(value);
    }

    public static Buffer encodeBuffer(Object value) {
        return Json.encodeToBuffer(JsonCodecMapper.encode(value));
    }

    static {
        HashMap<Class, JsonCodec> map = new HashMap<Class, JsonCodec>();
        ServiceLoader<JsonCodec> codecServiceLoader = ServiceLoader.load(JsonCodec.class);
        for (JsonCodec j : codecServiceLoader) {
            map.put(j.getTargetClass(), j);
        }
        codecMap = map;
    }
}

