/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram;

import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import java.util.Map;

public class DatagramSocketOptionsConverter
implements JsonCodec<DatagramSocketOptions, JsonObject> {
    public static final DatagramSocketOptionsConverter INSTANCE = new DatagramSocketOptionsConverter();

    @Override
    public JsonObject encode(DatagramSocketOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public DatagramSocketOptions decode(JsonObject value) {
        return value != null ? new DatagramSocketOptions(value) : null;
    }

    @Override
    public Class<DatagramSocketOptions> getTargetClass() {
        return DatagramSocketOptions.class;
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, DatagramSocketOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "broadcast": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBroadcast((Boolean)member.getValue());
                    break;
                }
                case "ipV6": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setIpV6((Boolean)member.getValue());
                    break;
                }
                case "loopbackModeDisabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setLoopbackModeDisabled((Boolean)member.getValue());
                    break;
                }
                case "multicastNetworkInterface": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMulticastNetworkInterface((String)member.getValue());
                    break;
                }
                case "multicastTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMulticastTimeToLive(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(DatagramSocketOptions obj, JsonObject json) {
        DatagramSocketOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(DatagramSocketOptions obj, Map<String, Object> json) {
        json.put("broadcast", obj.isBroadcast());
        json.put("ipV6", obj.isIpV6());
        json.put("loopbackModeDisabled", obj.isLoopbackModeDisabled());
        if (obj.getMulticastNetworkInterface() != null) {
            json.put("multicastNetworkInterface", obj.getMulticastNetworkInterface());
        }
        json.put("multicastTimeToLive", obj.getMulticastTimeToLive());
    }
}

